

  <style>
    

    .our-reach-section {
      padding: 100px 20px;
      text-align: center;
      background: #076476;
      position: relative;
      overflow: hidden;
    }

    .our-reach-section::before {
      content: '';
      position: absolute;
      top: -100px;
      left: 0;
      width: 100%;
      height: 200px;
      background: #faf9fb;
      border-bottom-left-radius: 50% 20%;
      border-bottom-right-radius: 50% 20%;
      z-index: 0;
    }

    .our-reach-content {
      position: relative;
      z-index: 1;
      max-width: 900px;
      margin: auto;
    }

    .our-reach-content h2 {
      font-size: 2rem;
      margin-bottom: 10px;
    }

    .our-reach-content p {
      font-size: 0.95rem;
      color: #ccc;
      margin-bottom: 50px;
    }

    .stats {
      display: flex;
      justify-content: center;
      gap: 80px;
      flex-wrap: wrap;
    }

    .stat {
      border-right: 2px solid #333;
      padding: 0 40px;
    }

    .stat:last-child {
      border-right: none;
    }

    .count {
      font-size: 2.5rem;
      font-weight: bold;
    }

    .label {
      margin-top: 10px;
      font-weight: 600;
    }

    @media (max-width: 768px) {
      .stat {
        border-right: none;
        border-bottom: 2px solid #333;
        padding-bottom: 20px;
        margin-bottom: 20px;
      }
    }
  </style>
</head>
<body>

<section class="our-reach-section">
  <div class="our-reach-content">
    <h2 class="text-white pt-4">Our Reach</h2>
    <p class="text-white pt-4">Volunteers are the backbone of every organization – they not only carry the organization's ideals<br/>
       within them, but also spread the message far and beyond,</p>
    <div class="stats text-white">
      <div class="stat">
        <div class="count" data-target="650">0</div>
        <div class="label">Total Volunteers</div>
      </div>
      <div class="stat">
        <div class="count" data-target="350">0</div>
        <div class="label">Projects Done</div>
      </div>
      <div class="stat">
        <div class="count" data-target="2500">0</div>
        <div class="label">Empowerment</div>
      </div>
    </div>
  </div>
</section>

<script>
  const counters = document.querySelectorAll('.count');
  counters.forEach(counter => {
    counter.innerText = '0';
    const updateCounter = () => {
      const target = +counter.getAttribute('data-target');
      const current = +counter.innerText;
      const increment = target / 100;

      if (current < target) {
        counter.innerText = `${Math.ceil(current + increment)}`;
        setTimeout(updateCounter, 10);
      } else {
        counter.innerText = `${target}+`;
      }
    };
    updateCounter();
  });
</script>


