<!DOCTYPE html>
<html lang="en">
<head>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <style>
    .dropdown-submenu {
      position: relative;
    }

    .dropdown-submenu > .dropdown-menu {
      top: 0;
      left: 100%;
      margin-top: -1px;
      display: none;
    }

    .dropdown-submenu.show > .dropdown-menu {
      display: block;
    }
  </style>
</head>
<body>

<div class="container-fluid position-relative p-0">
  <nav class="navbar navbar-expand-lg navbar-light bg-white px-4 px-lg-5 py-3 py-lg-0">
    <a href="index.php" class="navbar-brand p-0">
      <img src="./img/logo.png" alt="Logo">
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
      <span class="fa fa-bars"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarCollapse">
      <div class="navbar-nav ms-auto py-0">
        <a href="index.php" class="nav-item nav-link active">Home</a>

        <!-- About Us Dropdown with Submenus -->
        <div class="nav-item dropdown">
          <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">About Us</a>
          <div class="dropdown-menu m-0">

            <a href="about-founder.php" class="dropdown-item">Founder</a>
            <a href="board-of-trustees.php" class="dropdown-item">Our Board of Trustees</a>

            <!-- Submenu under Our People -->
            <div class="dropdown-submenu">
              <a href="#" class="dropdown-item dropdown-toggle">Our People</a>
              <ul class="dropdown-menu">
                <li><a href="our-people.php" class="dropdown-item">Overview</a></li>
                <li><a href="team-members.php" class="dropdown-item">Team Members</a></li>
                <li><a href="advisors.php" class="dropdown-item">Advisors</a></li>
              </ul>
            </div>

            <a href="reach-presence.php" class="dropdown-item">Reach & Presence</a>
            <a href="awards.php" class="dropdown-item">Awards</a>

            <!-- Submenu under Bank Details -->
            <div class="dropdown-submenu">
              <a href="#" class="dropdown-item dropdown-toggle">Bank Details</a>
              <ul class="dropdown-menu">
                <li><a href="bank-details.php" class="dropdown-item">General Info</a></li>
                <li><a href="donation-info.php" class="dropdown-item">Donation Info</a></li>
              </ul>
            </div>

            <a href="history.php" class="dropdown-item">History</a>
          </div>
        </div>

        <a href="our-activities.php" class="nav-item nav-link">Our Activities</a>
        <a href="our-programs.php" class="nav-item nav-link">Our Programs</a>
        <a href="gallery.php" class="nav-item nav-link">Gallery</a>
        <a href="join-us.php" class="nav-item nav-link">Join Us</a>
        <a href="contact.php" class="nav-item nav-link">Contact Us</a>
      </div>
      <a href="donate-us.php" class="btn btn-primary rounded-pill text-white py-2 px-4 flex-wrap flex-sm-shrink-0">Donate Us</a>
    </div>
  </nav>
</div>

<!-- Bootstrap Bundle JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- Custom JS for Submenu Toggle -->
<script>
  document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.dropdown-submenu > a').forEach(function (element) {
      element.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        const submenu = this.parentElement;
        const isShown = submenu.classList.contains('show');

        // Close other open submenus
        submenu.parentElement.querySelectorAll('.dropdown-submenu.show').forEach(function (openSub) {
          openSub.classList.remove('show');
        });

        // Toggle current submenu
        if (!isShown) {
          submenu.classList.add('show');
        }
      });
    });

    // Close all submenus on outside click
    document.addEventListener('click', function () {
      document.querySelectorAll('.dropdown-submenu').forEach(function (submenu) {
        submenu.classList.remove('show');
      });
    });
  });
</script>

</body>
</html>
