<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>ETHAN LIFECARE FOUNDATION</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">
    <link rel="icon" type="image/x-icon" href="../img/ethan-logo.png">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;500;600&family=Playfair+Display:wght@400;500;600&display=swap" rel="stylesheet">

    <!-- Icon Font Stylesheet -->
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="lib/animate/animate.min.css" rel="stylesheet">
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">


    <!-- Customized Bootstrap Stylesheet -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="css/style.css" rel="stylesheet">
</head>

<body>

    <!-- Spinner Start -->
    <div id="spinner" class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
        <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
            <span class="sr-only">Loading...</span>
        </div>
    </div>
    <!-- Spinner End -->




    <!-- Navbar & Hero Start -->
    <?php include "header.php" ?>
    <!-- Navbar & Hero End -->


    <!-- Header Start -->
    <div class="container-fluid bg-breadcrumb">
        <div class="container text-center py-5" style="max-width: 900px;">
            <h3 class="text-white display-3 mb-4 wow fadeInDown" data-wow-delay="0.1s">About Us</h1>
                <ol class="breadcrumb justify-content-center mb-0 wow fadeInDown" data-wow-delay="0.3s">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item active text-primary">About</li>
                </ol>
        </div>
    </div>
    <!-- Header End -->





    <!-- About Start -->
    <div class="container-fluid about bg-light py-2">
        <div class="container py-5">
            <div class="row g-5 align-items-center">
                <div class="col-lg-5 wow fadeInLeft" data-wow-delay="0.2s">
                    <div class="about-img pb-5 ps-5">
                        <img src="./images/ABOUT.jpeg" class="img-fluid rounded w-100" style="object-fit: cover;" alt="Image">


                    </div>
                </div>
                <div class="col-lg-7 wow fadeInRight" data-wow-delay="0.4s">
                    <div class="section-title text-start mb-5">
                        <h4 class="sub-title pe-3 mb-0">About Us</h4>
                        <p class="mb-4" style="color: #000;">Welcome to ETHAN LIFECARE FOUNDATION, here we are driven by the commitment to create a positive change in the lives of individuals as well as communities. Our foundation is established on the principles of quality education, social welfare, and healthcare, aiming to uplift the underprivileged and contribute to the betterment of society.</p>
                        <p class="mb-2" style="color: #000;">We focus on providing life-saving humanitarian aid such as healthcare and education, with a particular emphasis on protecting and promoting human rights, especially for those endangered by discrimination or poverty.</p>
                        <p class="mb-2" style="color: #000;">Our objective is to be part of a system striving to make the world better and safer for the most marginalized people. We envision building a network committed to helping one another and serving the nation with transparency and ethical values, together in the most sustainable ways.</p>
                    </div>
                </div>
                <div class="col-12 wow fadeInRight" data-wow-delay="0.4s">
                    <div class="section-title text-start mb-5">
                        <h4 class="sub-title pe-3 mb-2">Governing Body</h4>
                        <ul class="list-unstyled">
                            <li><strong>Priya Anand (Founder & CEO):</strong> Skilled in business development, finance, operations, and marketing.</li>
                            <li><strong>Anjani Kumar Jha (IPS) (Board Member):</strong> Recognized for contributions in policing and education.</li>
                            <li><strong>Vinayak Gagrani (Board Member):</strong> Notable achievements in academia and societal contributions.</li>
                            <li><strong>Madhavi (Board Member):</strong> Focus on women's leadership and empowerment.</li>
                            <li><strong>Kumari Mamta (Advisory Team Member):</strong> Root level understanding of women and children's health and education.</li>
                            <li><strong>Sanu Kumar (Board Member):</strong> Profoundly skilled in mentoring and advising social entrepreneurs.</li>
                        </ul>
                    </div>
                </div>
                
                 <div class="col-12 wow fadeInRight" data-wow-delay="0.4s">
                    <div class="section-title text-start mb-5">
                        <h4 class="sub-title pe-3 mb-2">MISSION and VISION  </h4>
                        <p class="mb-4" style="color: #000;">Ethan Group focuses on life saving humanitarian aid like health care and education to make a difference in the society by protecting and promoting human rights, especially of those endangered by discrimination or poverty. Our objective is to be part of a system striving to make world better and safer for the most marginalized people. We envision building a network committed to helping one another and serving the nation with transparency and ethical values together in the most sustainable way. Our service is rendered to the remotest parts and beyond the call of duty to drive excellence. Well-being of women and children by facilitating medical care along with bridging the gap between the education system and disadvantaged sections is the core of our foundation. The NGO plays pivotal role in spreading awareness about diseases caused by anaemia and making arrangements with specialised doctors through wellness program and camps.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- About End -->

    <!-- Book Appointment Start -->
    <div class="container-fluid appointment py-5">
        <div class="container py-5">
            <div class=" text-start">
                <h4 class="sub-title pe-3 mb-3">OUR MISSION </h4>
                <h6 class="mb-4">At ETHAN LIFECARE FOUNDATION, our mission is clear: to promote education, advance healthcare solutions, and foster social welfare without the intention of making a profit. We believe in the transformative power of knowledge, the healing impact of healthcare, and the strength of communities coming together for a common purpose.</h6>
                <div class="row g-4">
                    <div class="col-sm-7">
                        <div class="d-flex flex-column h-100">
                            <div class="mb-4">
                                <h5 class="mb-3"><i class="fa fa-check text-primary me-2"></i>  Education for All</h5>
                                <p class="mb-0" style="color: #000;">We are dedicated to promote education, with a special focus on providing learning opportunities to the underprivileged sections of society. From schools and colleges to research centers, we strive to create a brighter future through knowledge.</p>
                            </div>
                            <div class="mb-4">
                                <h5 class="mb-3"><i class="fa fa-check text-primary me-2"></i>Advanced Healthcare</h5>
                                <p class="mb-0" style="color: #000;">Through medical and clinical research, we are committed to pushing the boundaries of healthcare. From supporting with the developed medical sciences to establishing healthcare facilities, our goal is to make quality healthcare accessible to all.</p>
                            </div>
                            <div class="mb-4">
                                <h5 class="mb-3"><i class="fa fa-check text-primary me-2"></i>Community-Centric Approach</h5>
                                <p class="mb-0" style="color: #000;">ETHAN LIFECARE FOUNDATION believes in a community-centric approach. We actively engage with local communities, understanding their unique needs, and tailoring our programs to create sustainable, positive change.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-5">
                        <div class="video h-100">
                            <img src="./img/7.jpg" class="img-fluid rounded w-100 h-100" style="object-fit: cover;" alt="">

                        </div>
                    </div>

                    <div class="col-12">
                        <h4 class="sub-title pe-3 mb-3">OUR OBJECTIVES</h4>
                        <div class="d-flex flex-column h-100">
                            <div class="mb-4">
                                <h5 class="mb-3"><i class="fa fa-check text-primary me-2"></i>  Educational Empowerment:</h5>
                                <p class="mb-0" style="color: #000;"> Empowering individuals through education and skill development, fostering a culture of continuous learning and growth.</p>
                            </div>
                            <div class="mb-4">
                                <h5 class="mb-3"><i class="fa fa-check text-primary me-2"></i>Healthcare Innovation:</h5>
                                <p class="mb-0" style="color: #000;"> Advancing medical sciences and therapies through research and development, with a focus on establishing healthcare facilities and supporting medical equipment development.</p>
                            </div>
                            <div class="mb-4">
                                <h5 class="mb-3"><i class="fa fa-check text-primary me-2"></i>Uniformity and Compliance:</h5>
                                <p class="mb-0" style="color: #000;"> Establishing uniform rules and regulations for our members, ensuring adherence to ethical and transparent practices.</p>
                            </div>
                            <div class="mb-4">
                                <h5 class="mb-3"><i class="fa fa-check text-primary me-2"></i>Community Support:</h5>
                                <p class="mb-0" style="color: #000;"> Supporting associations, institutions, and trusts aimed at benefiting employees, ex-employees, and their dependents.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php include "volunteers.php" ?>

    <!-- Footer Start -->
    <?php include "footer.php" ?>
    <!-- Footer End -->

    <!-- Copyright Start -->
    <div class="container-fluid copyright py-4">
        <div class="container">
            <div class="row g-4 align-items-center">
                <div class="col-md-6 text-center text-md-start mb-md-0">
                    <span class="text-white"><a href="#"><i class="fas fa-copyright text-light me-2"></i>ETHAN LIFECARE FOUNDATION</a>, All right reserved.</span>
                </div>
                <div class="col-md-6 text-center text-md-end text-white">
                    Powered By <a class="border-bottom" href="#">Creation Media</a>
                </div>
            </div>
        </div>
    </div>
    <!-- Copyright End -->

    <!-- Back to Top -->
    <a href="#" class="btn btn-primary btn-lg-square back-to-top"><i class="fa fa-arrow-up"></i></a>


    <!-- JavaScript Libraries -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="lib/wow/wow.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>


    <!-- Template Javascript -->
    <script src="js/main.js"></script>

</body>

</html>