<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <title>NAYEE ASHA</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">
    <link rel="icon" type="image/x-icon" href="./img/logo.png">
    <link rel="apple-touch-icon" sizes="180x180" href="./img/logo.png">
    <meta name="google-site-verification" content="rGHzo6_alFkL61LkizzlT0-Xk3i-kzB6tABF-pu1ksw" />
    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;500;600&family=Playfair+Display:wght@400;500;600&display=swap" rel="stylesheet">

    <!-- Icon Font Stylesheet -->
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="lib/animate/animate.min.css" rel="stylesheet">
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">


    <!-- Customized Bootstrap Stylesheet -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="css/style.css" rel="stylesheet">
</head>

<body>

    <style>
        :root {
            --lightbox: rgb(0 0 0 / 0.75);
            --carousel-text: #fff;
        }

        body {
            margin: 1.5rem 0 3.5rem;
        }

        @keyframes zoomin {
            0% {
                transform: scale(1);
            }

            50% {
                transform: scale(1.05);
            }

            100% {
                transform: scale(1);
            }
        }

        .gallery-item {
            display: block;
        }

        .gallery-item img {
            box-shadow: 0 1rem 1rem rgba(0, 0, 0, 0.15);
            transition: box-shadow 0.2s;
        }

        .gallery-item:hover img {
            box-shadow: 0 1rem 1rem rgba(0, 0, 0, 0.35);
        }

        .lightbox-modal .modal-content {
            background-color: var(--lightbox);
        }

        .lightbox-modal .btn-close {
            position: absolute;
            top: 1.25rem;
            right: 1.25rem;
            font-size: 1.25rem;
            z-index: 10;
            filter: invert(1) grayscale(100);
        }

        .lightbox-modal .modal-body {
            display: flex;
            align-items: center;
            padding: 0;
        }

        .lightbox-modal .lightbox-content {
            width: 100%;
        }

        .lightbox-modal .carousel-indicators {
            margin-bottom: 0;
        }

        .lightbox-modal .carousel-indicators [data-bs-target] {
            background-color: var(--carousel-text) !important;
        }

        .lightbox-modal .carousel-inner {
            width: 75%;
        }

        .lightbox-modal .carousel-inner img {
            animation: zoomin 10s linear infinite;
        }

        .lightbox-modal .carousel-item .carousel-caption {
            right: 0;
            bottom: 0;
            left: 0;
            padding-bottom: 2rem;
            background-color: var(--lightbox);
            color: var(--carousel-text) !important;
        }

        .lightbox-modal .carousel-control-prev,
        .lightbox-modal .carousel-control-next {
            width: auto;
        }

        .lightbox-modal .carousel-control-prev {
            left: 1.25rem;
        }

        .lightbox-modal .carousel-control-next {
            right: 1.25rem;
        }

        @media (min-width: 1400px) {
            .lightbox-modal .carousel-inner {
                max-width: 60%;
            }
        }

        [data-bs-theme="dark"] .lightbox-modal .carousel-control-next-icon,
        [data-bs-theme="dark"] .lightbox-modal .carousel-control-prev-icon {
            filter: none;
        }

        .btn-fullscreen-enlarge,
        .btn-fullscreen-exit {
            position: absolute;
            top: 1.25rem;
            right: 3.5rem;
            z-index: 10;
            border: 0;
            background: transparent;
            opacity: .6;
            font-size: 1.25rem;
        }

        .bi {
            display: inline-block;
            width: 1em;
            height: 1em;
            vertical-align: -0.035em;
            fill: currentcolor;
        }
    </style>




    <!-- Navbar & Hero Start -->
    <?php include "header.php" ?>
    <!-- Navbar & Hero End -->

    <!-- Header Start -->
    <div class="container-fluid bg-breadcrumb">
        <div class="container text-center py-5" style="max-width: 900px;">
            <h3 class="text-white display-3 mb-4 wow fadeInDown" data-wow-delay="0.1s">Our Gallery</h1>
                <ol class="breadcrumb justify-content-center mb-0 wow fadeInDown" data-wow-delay="0.3s">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item active text-primary">Our Gallery</li>
                </ol>
        </div>
    </div>
    <!-- Header End -->




    <!-- Gallery Start -->
    <div class="gallery bg-light">
        <div class="container py-5">
            <section class="photo-gallery">
                <div class="container">
                    <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 gallery-grid">
                        <?php 
                        $extensions = ['jpg', 'jpeg', 'png'];
                        for ($i = 1; $i <= 24; $i++): 
                            foreach ($extensions as $ext):
                                $filePath = "./img/gallery/{$i}.{$ext}";
                                if (file_exists($filePath)): ?>
                                    <div class="col">
                                        <a class="gallery-item" href="<?php echo $filePath; ?>" data-lightbox="gallery" data-title="Image <?php echo $i; ?> description">
                                            <img src="<?php echo $filePath; ?>" class="img-fluid" alt="Image <?php echo $i; ?> description">
                                        </a>
                                    </div>
                                <?php break; endif; 
                            endforeach; 
                        endfor; 
                        ?>
                    </div>
                </div>
            </section>



            <div class="modal fade lightbox-modal" id="lightbox-modal" tabindex="-1">
                <div class="modal-dialog modal-dialog-centered modal-fullscreen">
                    <div class="modal-content">
                        <button type="button" class="btn-fullscreen-enlarge" aria-label="Enlarge fullscreen">
                            <svg class="bi">
                                <use href="#enlarge"></use>
                            </svg>
                        </button>
                        <button type="button" class="btn-fullscreen-exit d-none" aria-label="Exit fullscreen">
                            <svg class="bi">
                                <use href="#exit"></use>
                            </svg>
                        </button>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        <div class="modal-body">
                            <div class="lightbox-content">
                                <!-- JS content here -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <!-- Footer Start -->
        <?php include "footer.php" ?>
        <!-- Footer End -->
    </div>

    <!-- Lightbox CSS and JS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/css/lightbox.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/js/lightbox.min.js"></script>



    <!-- Back to Top -->
    <a href="#" class="btn btn-primary btn-lg-square back-to-top"><i class="fa fa-arrow-up"></i></a>


    <!-- JavaScript Libraries -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="lib/wow/wow.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>


    <!-- Template Javascript -->
    <script src="js/main.js"></script>

    <script>
        const html = document.querySelector('html');
        html.setAttribute('data-bs-theme', 'dark');

        document.addEventListener('DOMContentLoaded', () => {
            // --- Create LightBox
            const galleryGrid = document.querySelector(".gallery-grid");
            const links = galleryGrid.querySelectorAll("a");
            const imgs = galleryGrid.querySelectorAll("img");
            const lightboxModal = document.getElementById("lightbox-modal");
            const bsModal = new bootstrap.Modal(lightboxModal);
            const modalBody = lightboxModal.querySelector(".lightbox-content");

            function createCaption(caption) {
                return `<div class="carousel-caption d-none d-md-block">
        <h4 class="m-0">${caption}</h4>
      </div>`;
            }

            function createIndicators(img) {
                let markup = "",
                    i, len;

                const countSlides = links.length;
                const parentCol = img.closest('.col');
                const curIndex = [...parentCol.parentElement.children].indexOf(parentCol);

                for (i = 0, len = countSlides; i < len; i++) {
                    markup += `
        <button type="button" data-bs-target="#lightboxCarousel"
          data-bs-slide-to="${i}"
          ${i === curIndex ? 'class="active" aria-current="true"' : ''}
          aria-label="Slide ${i + 1}">
        </button>`;
                }

                return markup;
            }

            function createSlides(img) {
                let markup = "";
                const currentImgSrc = img.closest('.gallery-item').getAttribute("href");

                for (const img of imgs) {
                    const imgSrc = img.closest('.gallery-item').getAttribute("href");
                    const imgAlt = img.getAttribute("alt");

                    markup += `
        <div class="carousel-item${currentImgSrc === imgSrc ? " active" : ""}">
          <img class="d-block img-fluid w-100" src=${imgSrc} alt="${imgAlt}">
          ${imgAlt ? createCaption(imgAlt) : ""}
        </div>`;
                }

                return markup;
            }

            function createCarousel(img) {
                const markup = `
      <!-- Lightbox Carousel -->
      <div id="lightboxCarousel" class="carousel slide carousel-fade" data-bs-ride="true">
        <!-- Indicators/dots -->
        <div class="carousel-indicators">
          ${createIndicators(img)}
        </div>
        <!-- Wrapper for Slides -->
        <div class="carousel-inner justify-content-center mx-auto">
          ${createSlides(img)}
        </div>
        <!-- Controls/icons -->
        <button class="carousel-control-prev" type="button" data-bs-target="#lightboxCarousel" data-bs-slide="prev">
          <span class="carousel-control-prev-icon" aria-hidden="true"></span>
          <span class="visually-hidden">Previous</span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#lightboxCarousel" data-bs-slide="next">
          <span class="carousel-control-next-icon" aria-hidden="true"></span>
          <span class="visually-hidden">Next</span>
        </button>
      </div>
      `;

                modalBody.innerHTML = markup;
            }

            for (const link of links) {
                link.addEventListener("click", function(e) {
                    e.preventDefault();
                    const currentImg = link.querySelector("img");
                    const lightboxCarousel = document.getElementById("lightboxCarousel");

                    if (lightboxCarousel) {
                        const parentCol = link.closest('.col');
                        const index = [...parentCol.parentElement.children].indexOf(parentCol);

                        const bsCarousel = new bootstrap.Carousel(lightboxCarousel);
                        bsCarousel.to(index);
                    } else {
                        createCarousel(currentImg);
                    }

                    bsModal.show();
                });
            }

            // --- Support Fullscreen
            const fsEnlarge = document.querySelector(".btn-fullscreen-enlarge");
            const fsExit = document.querySelector(".btn-fullscreen-exit");

            function enterFS() {
                lightboxModal.requestFullscreen().then({}).catch(err => {
                    alert(`Error attempting to enable full-screen mode: ${err.message} (${err.name})`);
                });
                fsEnlarge.classList.toggle("d-none");
                fsExit.classList.toggle("d-none");
            }

            function exitFS() {
                document.exitFullscreen();
                fsExit.classList.toggle("d-none");
                fsEnlarge.classList.toggle("d-none");
            }

            fsEnlarge.addEventListener("click", (e) => {
                e.preventDefault();
                enterFS();
            });

            fsExit.addEventListener("click", (e) => {
                e.preventDefault();
                exitFS();
            });
        })
    </script>

</body>

</html>